( function( api ) {

	// Extends our custom "fast-food-pizza" section.
	api.sectionConstructor['fast-food-pizza'] = api.Section.extend( {

		// No events for this type of section.
		attachEvents: function () {},

		// Always make the section active.
		isContextuallyActive: function () {
			return true;
		}
	} );

} )( wp.customize );

(function ($) {
    function ResetDemoSettings() {
        if (!confirm("Are you sure you want to reset demo import settings?")) return;

        $.post(ajaxurl, { action: 'fast_food_pizza_reset_demo_import_settings' }, function () {
            location.reload();
        });
    }

    window.ResetDemoSettings = ResetDemoSettings;
})(jQuery);

(function ($, wp) {
    function ResetGlobalColor() {
        if (confirm("Are you sure you want to reset global color settings?")) {
            wp.customize.instance("fast_food_pizza_first_color").set("#dc3836");
			wp.customize.instance("fast_food_pizza_second_color").set("#fac717");
        }
    }

    window.ResetGlobalColor = ResetGlobalColor;
})(jQuery, wp);