<?php
	$fast_food_pizza_first_color = get_theme_mod('fast_food_pizza_first_color');
	$fast_food_pizza_second_color = get_theme_mod('fast_food_pizza_second_color');
	$fast_food_pizza_custom_css ='';

	/*------------------ Global First Color -----------*/

	if ($fast_food_pizza_first_color) {
		$fast_food_pizza_custom_css .= ':root {';
		$fast_food_pizza_custom_css .= '--first-theme-color: ' . esc_attr($fast_food_pizza_first_color) . ' !important;';
		$fast_food_pizza_custom_css .= '} ';
	}

	/*------------------ Global Second Color -----------*/

	if ($fast_food_pizza_second_color) {
		$fast_food_pizza_custom_css .= ':root {';
		$fast_food_pizza_custom_css .= '--second-theme-color: ' . esc_attr($fast_food_pizza_second_color) . ' !important;';
		$fast_food_pizza_custom_css .= '} ';
	}

	/*---------------------------Width Layout -------------------*/
	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_width_layout_options','Default');
    if($fast_food_pizza_theme_lay == 'Default'){
		$fast_food_pizza_custom_css .='body{';
			$fast_food_pizza_custom_css .='max-width: 100%;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Container Layout'){
		$fast_food_pizza_custom_css .='body{';
			$fast_food_pizza_custom_css .='width: 100%;padding-right: 15px;padding-left: 15px;margin-right: auto;margin-left: auto;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Box Layout'){
		$fast_food_pizza_custom_css .='body{';
			$fast_food_pizza_custom_css .='max-width: 1140px; width: 100%; padding-right: 15px; padding-left: 15px; margin-right: auto; margin-left: auto;';
		$fast_food_pizza_custom_css .='}';
	}

	/*-------------- Footer Text -------------------*/
	$fast_food_pizza_footer_text_align = get_theme_mod('fast_food_pizza_footer_text_align');
	$fast_food_pizza_custom_css .='.copyright-wrapper{';
		$fast_food_pizza_custom_css .='text-align: '.esc_attr($fast_food_pizza_footer_text_align).';';
	$fast_food_pizza_custom_css .='}';
	$fast_food_pizza_custom_css .='
	@media screen and (max-width:575px) {
		.copyright-wrapper{';
			$fast_food_pizza_custom_css .='text-align: center;'.esc_attr($fast_food_pizza_footer_text_align).'';
	$fast_food_pizza_custom_css .='} }';

	$fast_food_pizza_footer_text_padding = get_theme_mod('fast_food_pizza_footer_text_padding');
	$fast_food_pizza_custom_css .='.copyright-wrapper{';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_footer_text_padding).'px; padding-bottom: '.esc_attr($fast_food_pizza_footer_text_padding).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_footer_bg_color = get_theme_mod('fast_food_pizza_footer_bg_color');
	$fast_food_pizza_custom_css .='.footer-wp{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_footer_bg_color).';';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_footer_bg_image = get_theme_mod('fast_food_pizza_footer_bg_image');
	if($fast_food_pizza_footer_bg_image != false){
		$fast_food_pizza_custom_css .='.footer-wp{';
			$fast_food_pizza_custom_css .='background: url('.esc_attr($fast_food_pizza_footer_bg_image).'); background-size: cover;';
		$fast_food_pizza_custom_css .='}';
	}

	// Footer Attatchment
	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_footer_attatchment','scroll');
	if($fast_food_pizza_theme_lay == 'fixed'){
		$fast_food_pizza_custom_css .='.footer-wp{';
			$fast_food_pizza_custom_css .='background-attachment: fixed;';
		$fast_food_pizza_custom_css .='}';
	}elseif ($fast_food_pizza_theme_lay == 'scroll'){
		$fast_food_pizza_custom_css .='.footer-wp{';
			$fast_food_pizza_custom_css .='background-attachment: scroll;';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_footer_heading_font_weight = get_theme_mod( 'fast_food_pizza_footer_heading_font_weight','500');
	if($fast_food_pizza_footer_heading_font_weight != ''){
		$fast_food_pizza_custom_css .='.footer-wp h3, .footer-wp .wp-block-heading{';
			$fast_food_pizza_custom_css .='font-weight: '.esc_attr($fast_food_pizza_footer_heading_font_weight).';';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_footer_heading = get_theme_mod( 'fast_food_pizza_footer_heading','Left');
    if($fast_food_pizza_footer_heading == 'Left'){
		$fast_food_pizza_custom_css .='.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
		$fast_food_pizza_custom_css .='text-align: left;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_footer_heading == 'Center'){
		$fast_food_pizza_custom_css .='.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
			$fast_food_pizza_custom_css .='text-align: center;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
			$fast_food_pizza_custom_css .='margin: 7px auto;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
				$fast_food_pizza_custom_css .='text-align: left;';
				$fast_food_pizza_custom_css .='}
			.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
				$fast_food_pizza_custom_css .='margin: 7px 0 0;';
				$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_footer_heading == 'Right'){
		$fast_food_pizza_custom_css .='.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
			$fast_food_pizza_custom_css .='text-align: right; padding-bottom: 25px;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp .widget, .footer-wp aside{';
			$fast_food_pizza_custom_css .='position: relative;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
			$fast_food_pizza_custom_css .='position: absolute; right: 0;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
				$fast_food_pizza_custom_css .='text-align: left;';
				$fast_food_pizza_custom_css .='}
			.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
				$fast_food_pizza_custom_css .='left: 0;';
				$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_footer_content = get_theme_mod( 'fast_food_pizza_footer_content','Left');
    if($fast_food_pizza_footer_content == 'Left'){
		$fast_food_pizza_custom_css .='.footer-wp .widget{';
		$fast_food_pizza_custom_css .='text-align: left;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_footer_content == 'Center'){
		$fast_food_pizza_custom_css .='.footer-wp .widget{';
			$fast_food_pizza_custom_css .='text-align: center;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp .widget{';
				$fast_food_pizza_custom_css .='text-align: left;';
				$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_footer_content == 'Right'){
		$fast_food_pizza_custom_css .='.footer-wp .widget{';
			$fast_food_pizza_custom_css .='text-align: right;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp .widget{';
				$fast_food_pizza_custom_css .='text-align: left;';
				$fast_food_pizza_custom_css .='} }';
	}

	// footer heading font size
	$fast_food_pizza_footer_heading_font_size = get_theme_mod('fast_food_pizza_footer_heading_font_size');
	$fast_food_pizza_custom_css .='.footer-wp h3{';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_footer_heading_font_size).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_footer_text_tranform','Capitalize');
    if($fast_food_pizza_theme_lay == 'Uppercase'){
		$fast_food_pizza_custom_css .='.footer-wp h3{';
			$fast_food_pizza_custom_css .='text-transform: uppercase;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Lowercase'){
		$fast_food_pizza_custom_css .='.footer-wp h3{';
			$fast_food_pizza_custom_css .='text-transform: lowercase;';
		$fast_food_pizza_custom_css .='}';
	}
	else if($fast_food_pizza_theme_lay == 'Capitalize'){
		$fast_food_pizza_custom_css .='.footer-wp h3{';
			$fast_food_pizza_custom_css .='text-transform: capitalize;';
		$fast_food_pizza_custom_css .='}';
	}

    // footer image position
	$fast_food_pizza_footer_img_position = get_theme_mod('fast_food_pizza_footer_img_position','center center');
	if($fast_food_pizza_footer_img_position != false){
		$fast_food_pizza_custom_css .='.footer-wp{';
			$fast_food_pizza_custom_css .='background-position: '.esc_attr($fast_food_pizza_footer_img_position).'!important;';
		$fast_food_pizza_custom_css .='}';
	}		

	// footer padding
	$fast_food_pizza_footer_padding = get_theme_mod('fast_food_pizza_footer_padding');
	$fast_food_pizza_custom_css .='.footer-wp{';
		$fast_food_pizza_custom_css .='padding: '.esc_attr($fast_food_pizza_footer_padding).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_copyright_text_font_size = get_theme_mod('fast_food_pizza_copyright_text_font_size', 15);
	$fast_food_pizza_custom_css .='.copyright-wrapper p, .copyright-wrapper a{';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_copyright_text_font_size).'px;';
	$fast_food_pizza_custom_css .='}';

   //Footer Style 
	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_footer_template','fast_food_pizza-footer-one');
    if($fast_food_pizza_theme_lay == 'fast_food_pizza-footer-one'){
		$fast_food_pizza_custom_css .='.footer-wp{';
			$fast_food_pizza_custom_css .='';
		$fast_food_pizza_custom_css .='}';

	}else if($fast_food_pizza_theme_lay == 'fast_food_pizza-footer-two'){
		$fast_food_pizza_custom_css .='.footer-wp {';
			$fast_food_pizza_custom_css .='background: #E3F2FD !important;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp p,.footer-wp span,.footer-wp li a,.footer-wp #wp-calendar caption,.footer-wp #wp-calendar td,.footer-wp #wp-calendar th, .footer-wp, .footer-wp h3, .footer-wp a.rsswidget, .footer-wp #wp-calendar a, .copyright a, .footer-wp .custom_details, .footer-wp ins span, .footer-wp .tagcloud a, .main-inner-box span.entry-date a, nav.woocommerce-MyAccount-navigation ul li:hover a, .footer-wp ul li a, .footer-wp table, .footer-wp th, .footer-wp td, .footer-wp caption, #sidebar caption,.footer-wp nav.wp-calendar-nav a,.footer-wp .search-form .search-field, .footer-wp .rssSummary, .footer-wp ul li{';
			$fast_food_pizza_custom_css .='color:#000 !important;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp p{';
			$fast_food_pizza_custom_css .='color:#000 !important;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp ul li::before{';
			$fast_food_pizza_custom_css .='background:#000;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp table, .footer-wp th, .footer-wp td,.footer-wp.search-form .search-field,.footer-wp .tagcloud a{';
			$fast_food_pizza_custom_css .='border: 1px solid #000;';
		$fast_food_pizza_custom_css .='}';

	}else if($fast_food_pizza_theme_lay == 'fast_food_pizza-footer-three'){
		$fast_food_pizza_custom_css .='.footer-wp {';
			$fast_food_pizza_custom_css .='background: #0A0A1F !important;;';
		$fast_food_pizza_custom_css .='}';
	}
	else if($fast_food_pizza_theme_lay == 'fast_food_pizza-footer-four'){
		$fast_food_pizza_custom_css .='.footer-wp {';
			$fast_food_pizza_custom_css .='background: #F5F5DC !important;;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp p,.footer-wp span,.footer-wp li a,.footer-wp #wp-calendar caption,.footer-wp #wp-calendar td,.footer-wp #wp-calendar th, .footer-wp, .footer-wp h3, .footer-wp a.rsswidget, .footer-wp #wp-calendar a, .copyright a, .footer-wp .custom_details, .footer-wp ins span, .footer-wp .tagcloud a, .main-inner-box span.entry-date a, nav.woocommerce-MyAccount-navigation ul li:hover a, .footer-wp ul li a, .footer-wp table, .footer-wp th, .footer-wp td, .footer-wp caption, #sidebar caption,.footer-wp nav.wp-calendar-nav a,.footer-wp .search-form .search-field, .footer-wp .rssSummary, .footer-wp ul li{';
			$fast_food_pizza_custom_css .='color:#000 !important;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp p{';
			$fast_food_pizza_custom_css .='color:#000 !important;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp ul li::before{';
			$fast_food_pizza_custom_css .='background:#000;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.footer-wp table, .footer-wp th, .footer-wp td,.footer-wp.search-form .search-field,.footer-wp .tagcloud a{';
			$fast_food_pizza_custom_css .='border: 1px solid #000;';
		$fast_food_pizza_custom_css .='}';
	}
    else if($fast_food_pizza_theme_lay == 'fast_food_pizza-footer-five'){
	$fast_food_pizza_custom_css .='.footer-wp {';
		$fast_food_pizza_custom_css .='background: #333333 !important;;';
	$fast_food_pizza_custom_css .='}';
   }
   
	//Footer Social Icon Alignment
	$fast_food_pizza_footer_icon_alignment = get_theme_mod( 'fast_food_pizza_footer_icon_alignment','center');
    if($fast_food_pizza_footer_icon_alignment == 'left'){
		$fast_food_pizza_custom_css .='footer .socialicons{';
			$fast_food_pizza_custom_css .='text-align:left !important;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_footer_icon_alignment == 'center'){
		$fast_food_pizza_custom_css .='footer .socialicons{';
			$fast_food_pizza_custom_css .='text-align:center !important;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_footer_icon_alignment == 'right'){
		$fast_food_pizza_custom_css .='footer .socialicons{';
			$fast_food_pizza_custom_css .='text-align:right !important;';
		$fast_food_pizza_custom_css .='}';
	}	   

	//Social icon color
	$fast_food_pizza_social_icon_color = get_theme_mod('fast_food_pizza_social_icon_color');
	$fast_food_pizza_custom_css .='.social-icon i{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_social_icon_color).' !important;';
	$fast_food_pizza_custom_css .='}'; 	

	/*------------- Back to Top  -------------------*/
	$fast_food_pizza_back_to_top_border_radius = get_theme_mod('fast_food_pizza_back_to_top_border_radius');
	$fast_food_pizza_custom_css .='#scrollbutton {';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_back_to_top_border_radius).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_scroll_icon_font_size = get_theme_mod('fast_food_pizza_scroll_icon_font_size', 22);
	$fast_food_pizza_custom_css .='#scrollbutton {';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_scroll_icon_font_size).'px;';
	$fast_food_pizza_custom_css .='}';

	// letter spacing
	$fast_food_pizza_footer_heading_letter_spacing = get_theme_mod('fast_food_pizza_footer_heading_letter_spacing',1);
	$fast_food_pizza_custom_css .='.footer-wp h3{';
	$fast_food_pizza_custom_css .='letter-spacing: '.esc_attr($fast_food_pizza_footer_heading_letter_spacing).'px;';
	$fast_food_pizza_custom_css .='}';

	// back to top icon color
	$fast_food_pizza_scroll_icon_color = get_theme_mod('fast_food_pizza_scroll_icon_color');
	$fast_food_pizza_custom_css .='#scrollbutton{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_scroll_icon_color).';';
	$fast_food_pizza_custom_css .='}';

	// back to top icon hover color
	$fast_food_pizza_scroll_icon_hover_color = get_theme_mod('fast_food_pizza_scroll_icon_hover_color');
	$fast_food_pizza_custom_css .='#scrollbutton:hover{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_scroll_icon_hover_color).';';
	$fast_food_pizza_custom_css .='}';

	// back to top bg color
	$fast_food_pizza_scroll_icon_background = get_theme_mod('fast_food_pizza_scroll_icon_background');
	$fast_food_pizza_custom_css .='#scrollbutton{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_scroll_icon_background).';';
		$fast_food_pizza_custom_css .='border-color: '.esc_attr($fast_food_pizza_scroll_icon_background).';';
	$fast_food_pizza_custom_css .='}';

	// back to top bg hover color
	$fast_food_pizza_scroll_icon_background_hover = get_theme_mod('fast_food_pizza_scroll_icon_background_hover');
	$fast_food_pizza_custom_css .='#scrollbutton:hover{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_scroll_icon_background_hover).';';
		$fast_food_pizza_custom_css .='border-color: '.esc_attr($fast_food_pizza_scroll_icon_background_hover).';';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_top_bottom_scroll_padding = get_theme_mod('fast_food_pizza_top_bottom_scroll_padding', 7);
	$fast_food_pizza_custom_css .='#scrollbutton {';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_top_bottom_scroll_padding).'px; padding-bottom: '.esc_attr($fast_food_pizza_top_bottom_scroll_padding).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_left_right_scroll_padding = get_theme_mod('fast_food_pizza_left_right_scroll_padding', 17);
	$fast_food_pizza_custom_css .='#scrollbutton {';
		$fast_food_pizza_custom_css .='padding-left: '.esc_attr($fast_food_pizza_left_right_scroll_padding).'px; padding-right: '.esc_attr($fast_food_pizza_left_right_scroll_padding).'px;';
	$fast_food_pizza_custom_css .='}';

	//First Cap
	$fast_food_pizza_show_first_caps = get_theme_mod('fast_food_pizza_show_first_caps', 'false');
	if($fast_food_pizza_show_first_caps == 'true' ){
	$fast_food_pizza_custom_css .='.blog-section .mainbox .new-text p:nth-of-type(1)::first-letter{';
	$fast_food_pizza_custom_css .=' font-size: 55px; font-weight: 600;';
	$fast_food_pizza_custom_css .=' margin-right: 6px;';
	$fast_food_pizza_custom_css .=' line-height: 1;';
	$fast_food_pizza_custom_css .='}';
	}elseif($fast_food_pizza_show_first_caps == 'false' ){
	$fast_food_pizza_custom_css .='.blog-section .mainbox .new-text p:nth-of-type(1)::first-letter {';
	$fast_food_pizza_custom_css .='display: none;';
	$fast_food_pizza_custom_css .='}';
	}

	/*-------------- Post Button  -------------------*/

	$fast_food_pizza_btn_font_size_option = get_theme_mod('fast_food_pizza_btn_font_size_option');
	$fast_food_pizza_custom_css .='.postbtn a{';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_btn_font_size_option).'px !important;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_tranform_button_text','Capitalize');
    if($fast_food_pizza_theme_lay == 'Uppercase'){
		$fast_food_pizza_custom_css .='.postbtn a{';
			$fast_food_pizza_custom_css .='text-transform: Uppercase;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Lowercase'){
		$fast_food_pizza_custom_css .='.postbtn a{';
			$fast_food_pizza_custom_css .='text-transform: Lowercase;';
		$fast_food_pizza_custom_css .='}';
	}
	else if($fast_food_pizza_theme_lay == 'Capitalize'){
		$fast_food_pizza_custom_css .='.postbtn a{';
			$fast_food_pizza_custom_css .='text-transform: Capitalize;';
		$fast_food_pizza_custom_css .='}';
	}

	// button font weight
	$fast_food_pizza_button_font_weight = get_theme_mod( 'fast_food_pizza_button_font_weight','500');
	if($fast_food_pizza_button_font_weight != ''){
		$fast_food_pizza_custom_css .='.postbtn a{';
			$fast_food_pizza_custom_css .='font-weight: '.esc_attr($fast_food_pizza_button_font_weight).';';
		$fast_food_pizza_custom_css .='}';
	}

	//Button hover effect
	$fast_food_pizza_button_hover_effect = get_theme_mod('fast_food_pizza_button_hover_effect', 'disable');
	if ($fast_food_pizza_button_hover_effect !== 'disable') {
		$fast_food_pizza_custom_css .= '.postbtn a:hover {';
		switch ($fast_food_pizza_button_hover_effect) {
			case 'pulse':
				$fast_food_pizza_custom_css .= 'animation: pulse 0.5s ease-in-out;';
				break;
			case 'rubberBand':
				$fast_food_pizza_custom_css .= 'animation: rubberBand 0.5s ease-in-out;';
				break;
			case 'swing':
				$fast_food_pizza_custom_css .= 'animation: swing 0.5s ease-in-out;';
				break;
			case 'tada':
				$fast_food_pizza_custom_css .= 'animation: tada 0.5s ease-in-out;';
				break;
			case 'jello':
				$fast_food_pizza_custom_css .= 'animation: jello 0.5s ease-in-out;';
				break;
		}
		$fast_food_pizza_custom_css .= '}';
	}

	//keyframes for all animations
	$fast_food_pizza_custom_css .= '
	@keyframes pulse {
		0% { transform: scale(1); }
		50% { transform: scale(1.1); }
		100% { transform: scale(1); }
	}

	@keyframes rubberBand {
		0% { transform: scale(1); }
		30% { transform: scaleX(1.25) scaleY(0.75); }
		40% { transform: scaleX(0.75) scaleY(1.25); }
		50% { transform: scale(1); }
	}

	@keyframes swing {
		20% { transform: rotate(15deg); }
		40% { transform: rotate(-10deg); }
		60% { transform: rotate(5deg); }
		80% { transform: rotate(-5deg); }
		100% { transform: rotate(0deg); }
	}

	@keyframes tada {
		0% { transform: scale(1); }
		10%, 20% { transform: scale(0.9) rotate(-3deg); }
		30%, 50%, 70%, 90% { transform: scale(1.1) rotate(3deg); }
		40%, 60%, 80% { transform: scale(1.1) rotate(-3deg); }
		100% { transform: scale(1) rotate(0); }
	}

	@keyframes jello {
		0%, 11.1%, 100% { transform: none; }
		22.2% { transform: skewX(-12.5deg) skewY(-12.5deg); }
		33.3% { transform: skewX(6.25deg) skewY(6.25deg); }
		44.4% { transform: skewX(-3.125deg) skewY(-3.125deg); }
		55.5% { transform: skewX(1.5625deg) skewY(1.5625deg); }
		66.6% { transform: skewX(-0.78125deg) skewY(-0.78125deg); }
		77.7% { transform: skewX(0.390625deg) skewY(0.390625deg); }
		88.8% { transform: skewX(-0.1953125deg) skewY(-0.1953125deg); }
	}';
	
	$fast_food_pizza_post_button_padding_top = get_theme_mod('fast_food_pizza_post_button_padding_top');
	$fast_food_pizza_custom_css .='.postbtn a, #comments input[type="submit"].submit{';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_post_button_padding_top).'px; padding-bottom: '.esc_attr($fast_food_pizza_post_button_padding_top).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_post_button_padding_right = get_theme_mod('fast_food_pizza_post_button_padding_right');
	$fast_food_pizza_custom_css .='.postbtn a, #comments input[type="submit"].submit{';
		$fast_food_pizza_custom_css .='padding-left: '.esc_attr($fast_food_pizza_post_button_padding_right).'px; padding-right: '.esc_attr($fast_food_pizza_post_button_padding_right).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_post_button_border_radius = get_theme_mod('fast_food_pizza_post_button_border_radius');
	$fast_food_pizza_custom_css .='.postbtn a, #comments input[type="submit"].submit{';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_post_button_border_radius).'px;';
	$fast_food_pizza_custom_css .='}';

	// button letter spacing
	$fast_food_pizza_button_letter_spacing = get_theme_mod('fast_food_pizza_button_letter_spacing', '0');
	$fast_food_pizza_custom_css .='.postbtn a {';
		$fast_food_pizza_custom_css .='letter-spacing: '.esc_attr($fast_food_pizza_button_letter_spacing).'px;';
	$fast_food_pizza_custom_css .='}';			

	//Button Shape
	$fast_food_pizza_btn_shape = get_theme_mod('fast_food_pizza_btn_shape', 'Round');
	if($fast_food_pizza_btn_shape == 'Square' ){
		$fast_food_pizza_custom_css .='.inner-service .mainbox .postbtn a{';
			$fast_food_pizza_custom_css .=' border-radius: 0';
		$fast_food_pizza_custom_css .='}';
	}elseif($fast_food_pizza_btn_shape == 'Round' ){
		$fast_food_pizza_custom_css .='.inner-service .mainbox .postbtn a{';
			$fast_food_pizza_custom_css .=' border-radius: .3em';
		$fast_food_pizza_custom_css .='}';
	}elseif($fast_food_pizza_btn_shape == 'Pill' ){
		$fast_food_pizza_custom_css .='.inner-service .mainbox .postbtn a{';
			$fast_food_pizza_custom_css .=' border-radius: 2em;';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_post_comment_enable = get_theme_mod('fast_food_pizza_post_comment_enable',true);
	if($fast_food_pizza_post_comment_enable == false){
		$fast_food_pizza_custom_css .='#comments{';
			$fast_food_pizza_custom_css .='display: none;';
		$fast_food_pizza_custom_css .='}';
	}

	// preloader background image
	$fast_food_pizza_preloader_bg_image = get_theme_mod('fast_food_pizza_preloader_bg_image');
	if($fast_food_pizza_preloader_bg_image != false){
		$fast_food_pizza_custom_css .='.frame{';
			$fast_food_pizza_custom_css .='background: url('.esc_attr($fast_food_pizza_preloader_bg_image).'); background-size: cover;';
		$fast_food_pizza_custom_css .='}';
	}

	/*----------- Preloader Color Option  ----------------*/
	$fast_food_pizza_preloader_bg_color_option = get_theme_mod('fast_food_pizza_preloader_bg_color_option');
	$fast_food_pizza_preloader_icon_color_option = get_theme_mod('fast_food_pizza_preloader_icon_color_option');
	$fast_food_pizza_custom_css .='.frame{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_preloader_bg_color_option).';';
	$fast_food_pizza_custom_css .='}';
	$fast_food_pizza_custom_css .='.dot-1,.dot-2,.dot-3{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_preloader_icon_color_option).';';
	$fast_food_pizza_custom_css .='}';

	// preloader type
	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_preloader_type','First Preloader Type');
    if($fast_food_pizza_theme_lay == 'First Preloader Type'){
		$fast_food_pizza_custom_css .='.dot-1, .dot-2, .dot-3{';
			$fast_food_pizza_custom_css .='';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Second Preloader Type'){
		$fast_food_pizza_custom_css .='.dot-1, .dot-2, .dot-3{';
			$fast_food_pizza_custom_css .='border-radius:0;';
		$fast_food_pizza_custom_css .='}';
	}

	/*------------------ Skin Option  -------------------*/
	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_background_skin','Without Background');
    if($fast_food_pizza_theme_lay == 'With Background'){
		$fast_food_pizza_custom_css .='.inner-service,#sidebar .widget,.woocommerce ul.products li.product, .woocommerce-page ul.products li.product,.front-page-content,.background-img-skin{';
			$fast_food_pizza_custom_css .='background-color: #fff; padding:20px;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .='.login-box a{';
			$fast_food_pizza_custom_css .='background-color: #fff;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Without Background'){
		$fast_food_pizza_custom_css .='{';
			$fast_food_pizza_custom_css .='background-color: transparent;';
		$fast_food_pizza_custom_css .='}';
	}

	/*-------------- Woocommerce Button  -------------------*/
	$fast_food_pizza_woocommerce_button_padding_top = get_theme_mod('fast_food_pizza_woocommerce_button_padding_top',12);
	$fast_food_pizza_custom_css .='.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_woocommerce_button_padding_top).'px; padding-bottom: '.esc_attr($fast_food_pizza_woocommerce_button_padding_top).'px;';
	$fast_food_pizza_custom_css .='}';
	

	$fast_food_pizza_woocommerce_button_padding_right = get_theme_mod('fast_food_pizza_woocommerce_button_padding_right',15);
	$fast_food_pizza_custom_css .='.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{';
		$fast_food_pizza_custom_css .='padding-left: '.esc_attr($fast_food_pizza_woocommerce_button_padding_right).'px; padding-right: '.esc_attr($fast_food_pizza_woocommerce_button_padding_right).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woocommerce_button_border_radius = get_theme_mod('fast_food_pizza_woocommerce_button_border_radius',5);
	$fast_food_pizza_custom_css .='.woocommerce ul.products li.product .button, a.checkout-button.button.alt.wc-forward,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce a.added_to_cart{';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_woocommerce_button_border_radius).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_related_product_enable = get_theme_mod('fast_food_pizza_related_product_enable',true);
	if($fast_food_pizza_related_product_enable == false){
		$fast_food_pizza_custom_css .='.related.products{';
			$fast_food_pizza_custom_css .='display: none;';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_woocommerce_product_border_enable = get_theme_mod('fast_food_pizza_woocommerce_product_border_enable',true);
	if($fast_food_pizza_woocommerce_product_border_enable == false){
		$fast_food_pizza_custom_css .='.products li{';
			$fast_food_pizza_custom_css .='border: none;';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_woocommerce_product_padding_top = get_theme_mod('fast_food_pizza_woocommerce_product_padding_top',0);
	$fast_food_pizza_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_woocommerce_product_padding_top).'px !important; padding-bottom: '.esc_attr($fast_food_pizza_woocommerce_product_padding_top).'px !important;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woocommerce_product_padding_right = get_theme_mod('fast_food_pizza_woocommerce_product_padding_right',0);
	$fast_food_pizza_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$fast_food_pizza_custom_css .='padding-left: '.esc_attr($fast_food_pizza_woocommerce_product_padding_right).'px !important; padding-right: '.esc_attr($fast_food_pizza_woocommerce_product_padding_right).'px !important;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woocommerce_product_border_radius = get_theme_mod('fast_food_pizza_woocommerce_product_border_radius',3);
	$fast_food_pizza_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_woocommerce_product_border_radius).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woocommerce_product_box_shadow = get_theme_mod('fast_food_pizza_woocommerce_product_box_shadow', 0);
	$fast_food_pizza_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$fast_food_pizza_custom_css .='box-shadow: '.esc_attr($fast_food_pizza_woocommerce_product_box_shadow).'px '.esc_attr($fast_food_pizza_woocommerce_product_box_shadow).'px '.esc_attr($fast_food_pizza_woocommerce_product_box_shadow).'px #ddd;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woo_product_sale_top_bottom_padding = get_theme_mod('fast_food_pizza_woo_product_sale_top_bottom_padding', 0);
	$fast_food_pizza_woo_product_sale_left_right_padding = get_theme_mod('fast_food_pizza_woo_product_sale_left_right_padding', 0);
	$fast_food_pizza_custom_css .='.woocommerce span.onsale{';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_woo_product_sale_top_bottom_padding).'px; padding-bottom: '.esc_attr($fast_food_pizza_woo_product_sale_top_bottom_padding).'px; padding-left: '.esc_attr($fast_food_pizza_woo_product_sale_left_right_padding).'px; padding-right: '.esc_attr($fast_food_pizza_woo_product_sale_left_right_padding).'px; display:inline-block;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woo_product_sale_border_radius = get_theme_mod('fast_food_pizza_woo_product_sale_border_radius',0);
	$fast_food_pizza_custom_css .='.woocommerce span.onsale {';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_woo_product_sale_border_radius).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_woo_product_sale_position = get_theme_mod('fast_food_pizza_woo_product_sale_position', 'Left');
	if($fast_food_pizza_woo_product_sale_position == 'Right' ){
		$fast_food_pizza_custom_css .='.woocommerce ul.products li.product .onsale{';
			$fast_food_pizza_custom_css .=' left:auto; right:0;';
		$fast_food_pizza_custom_css .='}';
	}elseif($fast_food_pizza_woo_product_sale_position == 'Left' ){
		$fast_food_pizza_custom_css .='.woocommerce ul.products li.product .onsale{';
			$fast_food_pizza_custom_css .=' left:0; right:auto;';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_wooproduct_sale_font_size = get_theme_mod('fast_food_pizza_wooproduct_sale_font_size',14);
	$fast_food_pizza_custom_css .='.woocommerce span.onsale{';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_wooproduct_sale_font_size).'px;';
	$fast_food_pizza_custom_css .='}';

	// Responsive Media
	$fast_food_pizza_post_date = get_theme_mod( 'fast_food_pizza_display_post_date',true);
	if($fast_food_pizza_post_date == true && get_theme_mod( 'fast_food_pizza_metafields_date',true) != true){
    	$fast_food_pizza_custom_css .='.metabox .entry-date{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_post_date == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.metabox .entry-date{';
			$fast_food_pizza_custom_css .='display:inline-block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_post_date == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.metabox .entry-date{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_post_author = get_theme_mod( 'fast_food_pizza_display_post_author',true);
	if($fast_food_pizza_post_author == true && get_theme_mod( 'fast_food_pizza_metafields_author',true) != true){
    	$fast_food_pizza_custom_css .='.metabox .entry-author{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_post_author == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.metabox .entry-author{';
			$fast_food_pizza_custom_css .='display:inline-block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_post_author == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.metabox .entry-author{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_post_comment = get_theme_mod( 'fast_food_pizza_display_post_comment',true);
	if($fast_food_pizza_post_comment == true && get_theme_mod( 'fast_food_pizza_metafields_comment',true) != true){
    	$fast_food_pizza_custom_css .='.metabox .entry-comments{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_post_comment == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.metabox .entry-comments{';
			$fast_food_pizza_custom_css .='display:inline-block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_post_comment == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.metabox .entry-comments{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_post_time = get_theme_mod( 'fast_food_pizza_display_post_time',true);
	if($fast_food_pizza_post_time == true && get_theme_mod( 'fast_food_pizza_metafields_time',true) != true){
    	$fast_food_pizza_custom_css .='.metabox .entry-time{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_post_time == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.metabox .entry-time{';
			$fast_food_pizza_custom_css .='display:inline-block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_post_time == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.metabox .entry-time{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	if($fast_food_pizza_post_date == false && $fast_food_pizza_post_author == false && $fast_food_pizza_post_comment == false && $fast_food_pizza_post_time == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
    	$fast_food_pizza_custom_css .='.metabox {';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_metafields_date = get_theme_mod( 'fast_food_pizza_metafields_date',true);
	$fast_food_pizza_metafields_author = get_theme_mod( 'fast_food_pizza_metafields_author',true);
	$fast_food_pizza_metafields_comment = get_theme_mod( 'fast_food_pizza_metafields_comment',true);
	$fast_food_pizza_metafields_time = get_theme_mod( 'fast_food_pizza_metafields_time',true);
	if($fast_food_pizza_metafields_date == false && $fast_food_pizza_metafields_author == false && $fast_food_pizza_metafields_comment == false && $fast_food_pizza_metafields_time == false){
		$fast_food_pizza_custom_css .='@media screen and (min-width:576px) {';
    	$fast_food_pizza_custom_css .='.metabox {';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_slider = get_theme_mod( 'fast_food_pizza_display_slider',true);
	if($fast_food_pizza_slider == true && get_theme_mod( 'fast_food_pizza_slider_hide', true) == false){
    	$fast_food_pizza_custom_css .='.slider-circle{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_slider == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.slider-circle{';
			$fast_food_pizza_custom_css .='display:block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_slider == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.slider-circle{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_sidebar = get_theme_mod( 'fast_food_pizza_display_sidebar',true);
    if($fast_food_pizza_sidebar == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='#sidebar{';
			$fast_food_pizza_custom_css .='display:block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_sidebar == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='#sidebar{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_scroll = get_theme_mod( 'fast_food_pizza_display_scrolltop',true);
	if($fast_food_pizza_scroll == true && get_theme_mod( 'fast_food_pizza_hide_show_scroll',true) != true){
    	$fast_food_pizza_custom_css .='#scrollbutton {';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_scroll == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='#scrollbutton {';
			$fast_food_pizza_custom_css .='display:block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_scroll == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='#scrollbutton {';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_preloader = get_theme_mod( 'fast_food_pizza_display_preloader',false);
	if($fast_food_pizza_preloader == true && get_theme_mod( 'fast_food_pizza_preloader',false) == false){
		$fast_food_pizza_custom_css .='@media screen and (min-width:575px) {';
    	$fast_food_pizza_custom_css .='.frame{';
			$fast_food_pizza_custom_css .=' visibility: hidden;';
		$fast_food_pizza_custom_css .='} }';
	}
    if($fast_food_pizza_preloader == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.frame{';
			$fast_food_pizza_custom_css .='visibility:visible;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_preloader == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.frame{';
			$fast_food_pizza_custom_css .='visibility: hidden;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_search = get_theme_mod( 'fast_food_pizza_display_search_category',true);
	if($fast_food_pizza_search == true && get_theme_mod( 'fast_food_pizza_search_enable_disable',true) != true){
    	$fast_food_pizza_custom_css .='.search-cat-box{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_search == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.search-cat-box{';
			$fast_food_pizza_custom_css .='display:block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_search == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.search-cat-box{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	$fast_food_pizza_myaccount = get_theme_mod( 'fast_food_pizza_display_myaccount',true);
	if($fast_food_pizza_myaccount == true && get_theme_mod( 'fast_food_pizza_myaccount_enable_disable',true) != true){
    	$fast_food_pizza_custom_css .='.login-box{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} ';
	}
    if($fast_food_pizza_myaccount == true){
    	$fast_food_pizza_custom_css .='@media screen and (max-width:575px) {';
		$fast_food_pizza_custom_css .='.login-box{';
			$fast_food_pizza_custom_css .='display:block;';
		$fast_food_pizza_custom_css .='} }';
	}else if($fast_food_pizza_myaccount == false){
		$fast_food_pizza_custom_css .='@media screen and (max-width:575px){';
		$fast_food_pizza_custom_css .='.login-box{';
			$fast_food_pizza_custom_css .='display:none;';
		$fast_food_pizza_custom_css .='} }';
	}

	// social icons font size
	$fast_food_pizza_social_icons_size = get_theme_mod('fast_food_pizza_social_icons_size', 15);
	$fast_food_pizza_custom_css .='.bottom-header .social-icon a{';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_social_icons_size).'px;';
	$fast_food_pizza_custom_css .='}';

	// menu settings
	$fast_food_pizza_menu_font_size_option = get_theme_mod('fast_food_pizza_menu_font_size_option');
	$fast_food_pizza_custom_css .='.primary-navigation ul li a{';
		$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_menu_font_size_option).'px;';
	$fast_food_pizza_custom_css .='}';

	// menu top-bottom padding
	$fast_food_pizza_menu_top_bottom_padding = get_theme_mod('fast_food_pizza_menu_top_bottom_padding');
	$fast_food_pizza_custom_css .='.primary-navigation ul li a{';
		$fast_food_pizza_custom_css .='padding-top: '.esc_attr($fast_food_pizza_menu_top_bottom_padding).'px;';
		$fast_food_pizza_custom_css .='padding-bottom: '.esc_attr($fast_food_pizza_menu_top_bottom_padding).'px;';
	$fast_food_pizza_custom_css .='}';

	// menu left-right padding
	$fast_food_pizza_menu_left_right_padding = get_theme_mod('fast_food_pizza_menu_left_right_padding');
	$fast_food_pizza_custom_css .='.primary-navigation ul li a{';
		$fast_food_pizza_custom_css .='padding-left: '.esc_attr($fast_food_pizza_menu_left_right_padding).'px;';
		$fast_food_pizza_custom_css .='padding-right: '.esc_attr($fast_food_pizza_menu_left_right_padding).'px;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_text_tranform_menu','Uppercase');
    if($fast_food_pizza_theme_lay == 'Uppercase'){
		$fast_food_pizza_custom_css .='.primary-navigation a{';
			$fast_food_pizza_custom_css .='text-transform: Uppercase;';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == 'Lowercase'){
		$fast_food_pizza_custom_css .='.primary-navigation a{';
			$fast_food_pizza_custom_css .='text-transform: Lowercase;';
		$fast_food_pizza_custom_css .='}';
	}
	else if($fast_food_pizza_theme_lay == 'Capitalize'){
		$fast_food_pizza_custom_css .='.primary-navigation a{';
			$fast_food_pizza_custom_css .='text-transform: Capitalize;';
		$fast_food_pizza_custom_css .='}';
	}

	// menu font weight
	$fast_food_pizza_font_weight_option_menu = get_theme_mod( 'fast_food_pizza_font_weight_option_menu','500');
	if($fast_food_pizza_font_weight_option_menu != ''){
		$fast_food_pizza_custom_css .='.primary-navigation a, .primary-navigation ul li a{';
			$fast_food_pizza_custom_css .='font-weight: '.esc_attr($fast_food_pizza_font_weight_option_menu).';';
		$fast_food_pizza_custom_css .='}';
	}

	//  comment form width
	$fast_food_pizza_comment_form_width = get_theme_mod( 'fast_food_pizza_comment_form_width');
	$fast_food_pizza_custom_css .='#comments textarea{';
		$fast_food_pizza_custom_css .='width: '.esc_attr($fast_food_pizza_comment_form_width).'%;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_title_comment_form = get_theme_mod('fast_food_pizza_title_comment_form', 'Leave a Reply');
	if($fast_food_pizza_title_comment_form == ''){
		$fast_food_pizza_custom_css .='#comments h2#reply-title {';
			$fast_food_pizza_custom_css .='display: none;';
		$fast_food_pizza_custom_css .='}';
	}

	$fast_food_pizza_comment_form_button_content = get_theme_mod('fast_food_pizza_comment_form_button_content', 'Post Comment');
	if($fast_food_pizza_comment_form_button_content == ''){
		$fast_food_pizza_custom_css .='#comments p.form-submit {';
			$fast_food_pizza_custom_css .='display: none;';
		$fast_food_pizza_custom_css .='}';
	}

	// featured image setting
	$fast_food_pizza_image_border_radius = get_theme_mod('fast_food_pizza_image_border_radius', 0);
	$fast_food_pizza_custom_css .='.box-image img, .content_box img{';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_image_border_radius).'%;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_image_box_shadow = get_theme_mod('fast_food_pizza_image_box_shadow',0);
	$fast_food_pizza_custom_css .='.box-image img, .content_box img{';
		$fast_food_pizza_custom_css .='box-shadow: '.esc_attr($fast_food_pizza_image_box_shadow).'px '.esc_attr($fast_food_pizza_image_box_shadow).'px '.esc_attr($fast_food_pizza_image_box_shadow).'px #b5b5b5;';
	$fast_food_pizza_custom_css .='}';

	// single featured image setting
	$fast_food_pizza_single_image_border_radius = get_theme_mod('fast_food_pizza_single_image_border_radius', 0);
	$fast_food_pizza_custom_css .='.feature-box img{';
		$fast_food_pizza_custom_css .='border-radius: '.esc_attr($fast_food_pizza_single_image_border_radius).'%;';
	$fast_food_pizza_custom_css .='}';

	$fast_food_pizza_single_image_box_shadow = get_theme_mod('fast_food_pizza_single_image_box_shadow',0);
	$fast_food_pizza_custom_css .='.feature-box img{';
		$fast_food_pizza_custom_css .='box-shadow: '.esc_attr($fast_food_pizza_single_image_box_shadow).'px '.esc_attr($fast_food_pizza_single_image_box_shadow).'px '.esc_attr($fast_food_pizza_single_image_box_shadow).'px #b5b5b5;';
	$fast_food_pizza_custom_css .='}';

	// single featured image dimention
	$fast_food_pizza_single_post_featured_image_dimention = get_theme_mod('fast_food_pizza_single_post_featured_image_dimention', 'Default');
	$fast_food_pizza_single_post_featured_image_custom_width = get_theme_mod('fast_food_pizza_single_post_featured_image_custom_width');
	$fast_food_pizza_single_post_featured_image_custom_height = get_theme_mod('fast_food_pizza_single_post_featured_image_custom_height');
	if($fast_food_pizza_single_post_featured_image_dimention == 'Custom'){
		$fast_food_pizza_custom_css .='.single-post-page .feature-box img{';
			$fast_food_pizza_custom_css .='width: '.esc_attr($fast_food_pizza_single_post_featured_image_custom_width).'px!important; height: '.esc_attr($fast_food_pizza_single_post_featured_image_custom_height).'px!important;';
		$fast_food_pizza_custom_css .='}';
	}

	// category color
	$fast_food_pizza_category_color = get_theme_mod('fast_food_pizza_category_color');
	$fast_food_pizza_custom_css .='.type-post .category ul li a{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_category_color).';';
	$fast_food_pizza_custom_css .='}';

	// category hover color
	$fast_food_pizza_category_hover_color = get_theme_mod('fast_food_pizza_category_hover_color');
	$fast_food_pizza_custom_css .='.type-post .category ul li a:hover{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_category_hover_color).';';
	$fast_food_pizza_custom_css .='}';

	// Post Block
	$fast_food_pizza_post_block_option = get_theme_mod( 'fast_food_pizza_post_block_option','By Block');
    if($fast_food_pizza_post_block_option == 'By Without Block'){
		$fast_food_pizza_custom_css .='.gridbox .inner-service, .mainbox-post, .layout2, .mainbox, .layout3, .layout1, .post_format-post-format-video, .post_format-post-format-image, .post_format-post-format-audio, .post_format-post-format-gallery{';
			$fast_food_pizza_custom_css .='border:none; margin:30px 0;';
		$fast_food_pizza_custom_css .='}';
	}

	// post image 
	$fast_food_pizza_post_featured_color = get_theme_mod('fast_food_pizza_post_featured_color', '#5c727d');
	$fast_food_pizza_post_featured_image = get_theme_mod('fast_food_pizza_post_featured_image','Image');
	if($fast_food_pizza_post_featured_image == 'Color'){
		$fast_food_pizza_custom_css .='.post-color{';
			$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_post_featured_color).';';
		$fast_food_pizza_custom_css .='}';
	}

	// featured image dimention
	$fast_food_pizza_post_featured_image_dimention = get_theme_mod('fast_food_pizza_post_featured_image_dimention', 'Default');
	$fast_food_pizza_post_featured_image_custom_width = get_theme_mod('fast_food_pizza_post_featured_image_custom_width');
	$fast_food_pizza_post_featured_image_custom_height = get_theme_mod('fast_food_pizza_post_featured_image_custom_height');
	if($fast_food_pizza_post_featured_image_dimention == 'Custom'){
		$fast_food_pizza_custom_css .='.box-image img{';
			$fast_food_pizza_custom_css .='width: '.esc_attr($fast_food_pizza_post_featured_image_custom_width).'px; height: '.esc_attr($fast_food_pizza_post_featured_image_custom_height).'px;';
		$fast_food_pizza_custom_css .='}';
	}

	// featured image dimention
	$fast_food_pizza_custom_post_color_width = get_theme_mod('fast_food_pizza_custom_post_color_width');
	$fast_food_pizza_custom_post_color_height = get_theme_mod('fast_food_pizza_custom_post_color_height');
	if($fast_food_pizza_post_featured_image == 'Color'){
		$fast_food_pizza_custom_css .='.post-color{';
			$fast_food_pizza_custom_css .='width: '.esc_attr($fast_food_pizza_custom_post_color_width).'px; height: '.esc_attr($fast_food_pizza_custom_post_color_height).'px;';
		$fast_food_pizza_custom_css .='}';
	}

	// site title font size
	$fast_food_pizza_site_title_font_size = get_theme_mod('fast_food_pizza_site_title_font_size', 25);
	$fast_food_pizza_custom_css .='.logo .site-title{';
	$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_site_title_font_size).'px;';
	$fast_food_pizza_custom_css .='}';

	if ( !has_custom_logo() ) {
		$fast_food_pizza_custom_css .='.logo{';
			$fast_food_pizza_custom_css .='height: 140px; padding: 30px 15px;';
		$fast_food_pizza_custom_css .='}';
		$fast_food_pizza_custom_css .=' @media screen and (max-width:720px){
			.logo{';
			$fast_food_pizza_custom_css .='height: auto; padding: 15px;';
		$fast_food_pizza_custom_css .='} }';
	}

	// site logo padding 
	$fast_food_pizza_logo_padding = get_theme_mod('fast_food_pizza_logo_padding', '');
	$fast_food_pizza_custom_css .='.logo{';
	$fast_food_pizza_custom_css .='padding: '.esc_attr($fast_food_pizza_logo_padding).'px !important;';
	$fast_food_pizza_custom_css .='}';

	// site tagline font size
	$fast_food_pizza_site_tagline_font_size = get_theme_mod('fast_food_pizza_site_tagline_font_size', 13);
	$fast_food_pizza_custom_css .='p.site-description{';
	$fast_food_pizza_custom_css .='font-size: '.esc_attr($fast_food_pizza_site_tagline_font_size).'px;';
	$fast_food_pizza_custom_css .='}';

	// slider overlay
	$fast_food_pizza_enable_slider_overlay = get_theme_mod('fast_food_pizza_enable_slider_overlay', true);
	if($fast_food_pizza_enable_slider_overlay == false){
		$fast_food_pizza_custom_css .='#slider img{';
			$fast_food_pizza_custom_css .='opacity:1;';
		$fast_food_pizza_custom_css .='}';
	} 
	$fast_food_pizza_slider_overlay_color = get_theme_mod('fast_food_pizza_slider_overlay_color', true);
	if($fast_food_pizza_enable_slider_overlay != false){
		$fast_food_pizza_custom_css .='#slider{';
			$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_slider_overlay_color).';';
		$fast_food_pizza_custom_css .='}';
	}

	//slider heading color
	$fast_food_pizza_slider_heading_color = get_theme_mod('fast_food_pizza_slider_heading_color');
	$fast_food_pizza_custom_css .='#slider .carousel-caption h1{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_slider_heading_color).';';
	$fast_food_pizza_custom_css .='}';

	//slider text color
	$fast_food_pizza_slider_text_color = get_theme_mod('fast_food_pizza_slider_text_color');
	$fast_food_pizza_custom_css .='#slider .inner_carousel p{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_slider_text_color).';';
	$fast_food_pizza_custom_css .='}';

	//slider button text color
	$fast_food_pizza_slider_btn_text_color = get_theme_mod('fast_food_pizza_slider_btn_text_color');
	$fast_food_pizza_custom_css .='#slider .more-btn a{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_slider_btn_text_color).';';
	$fast_food_pizza_custom_css .='}';

	//slider button bg color
	$fast_food_pizza_slider_btn_bg_color = get_theme_mod('fast_food_pizza_slider_btn_bg_color');
	$fast_food_pizza_custom_css .='#slider .more-btn a{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_slider_btn_bg_color).';';
	$fast_food_pizza_custom_css .='}';
	
	/*------------ Slider Opacity -------------------*/
	$fast_food_pizza_theme_lay = get_theme_mod( 'fast_food_pizza_slider_opacity','0.7');
	if($fast_food_pizza_theme_lay == '0'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.1'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.1';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.2'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.2';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.3'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.3';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.4'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.4';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.5'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.5';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.6'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.6';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.7'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.7';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.8'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.8';
	$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_theme_lay == '0.9'){
	$fast_food_pizza_custom_css .='#slider .slider-bg img{';
		$fast_food_pizza_custom_css .='opacity:0.9';
	$fast_food_pizza_custom_css .='}';
	}
	
	// woocommerce Product Navigation
	$fast_food_pizza_wooproducts_nav = get_theme_mod('fast_food_pizza_wooproducts_nav', 'Yes');
	if($fast_food_pizza_wooproducts_nav == 'No'){
		$fast_food_pizza_custom_css .='.woocommerce nav.woocommerce-pagination{';
			$fast_food_pizza_custom_css .='display: none;';
		$fast_food_pizza_custom_css .='}';
	}

	// site title color
	$fast_food_pizza_site_title_color = get_theme_mod('fast_food_pizza_site_title_color');
	$fast_food_pizza_custom_css .='.site-title a{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_site_title_color).' !important;';
	$fast_food_pizza_custom_css .='}';

	// site tagline color
	$fast_food_pizza_site_tagline_color = get_theme_mod('fast_food_pizza_site_tagline_color');
	$fast_food_pizza_custom_css .='.site-description{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_site_tagline_color).' !important;';
	$fast_food_pizza_custom_css .='}';

	// site toggle button color
	$fast_food_pizza_toggle_button_color = get_theme_mod('fast_food_pizza_toggle_button_color');
	$fast_food_pizza_custom_css .='.toggle-menu i{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_toggle_button_color).' !important;';
	$fast_food_pizza_custom_css .='}';

	//Copyright text color
	$fast_food_pizza_copyright_text_color = get_theme_mod('fast_food_pizza_copyright_text_color');
	$fast_food_pizza_custom_css .='.copyright-wrapper p, .copyright-wrapper p a{';
		$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_copyright_text_color).';';
	$fast_food_pizza_custom_css .='}';

	//Copyright background css
	$fast_food_pizza_copyright_text_background = get_theme_mod('fast_food_pizza_copyright_text_background');
	$fast_food_pizza_custom_css .='.copyright-wrapper{';
		$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_copyright_text_background).';';
	$fast_food_pizza_custom_css .='}';

	// Menu Item Hover Style	
	$fast_food_pizza_menus_item = get_theme_mod( 'fast_food_pizza_menus_item_style','None');
    if($fast_food_pizza_menus_item == 'None'){
		$fast_food_pizza_custom_css .='.primary-navigation ul li a{';
			$fast_food_pizza_custom_css .='';
		$fast_food_pizza_custom_css .='}';
	}else if($fast_food_pizza_menus_item == 'Zoom In'){
		$fast_food_pizza_custom_css .='.primary-navigation ul li a:hover{';
			$fast_food_pizza_custom_css .='transition: all 0.3s ease-in-out !important; transform: scale(1.2) !important;';
		$fast_food_pizza_custom_css .='}';
	}	

	// menu color
	$fast_food_pizza_menu_color = get_theme_mod('fast_food_pizza_menu_color');
	$fast_food_pizza_custom_css .='.primary-navigation a, .primary-navigation ul li a, #site-navigation li a{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_menu_color).' !important;';
	$fast_food_pizza_custom_css .='}';

	// Sub menu color
	$fast_food_pizza_sub_menu_color = get_theme_mod('fast_food_pizza_sub_menu_color');

	$fast_food_pizza_custom_css .='.primary-navigation ul.sub-menu a, .primary-navigation ul.sub-menu li a, #site-navigation ul.sub-menu li a, .primary-navigation ul.children a, .primary-navigation ul.children li a, #site-navigation ul.children li a{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_sub_menu_color).' !important;';
	$fast_food_pizza_custom_css .='}';

	// menu hover color
	$fast_food_pizza_menu_hover_color = get_theme_mod('fast_food_pizza_menu_hover_color');

	$fast_food_pizza_custom_css .='.primary-navigation a:hover, .primary-navigation ul li a:hover, #site-navigation ul.sub-menu li a:hover, #site-navigation li a:hover, #site-navigation ul.children li a:hover{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_menu_hover_color).' !important;';
	$fast_food_pizza_custom_css .='}';

	// Sub menu hover color
	$fast_food_pizza_sub_menu_hover_color = get_theme_mod('fast_food_pizza_sub_menu_hover_color');
	$fast_food_pizza_custom_css .='.primary-navigation a:hover, .primary-navigation ul li a:hover, #site-navigation ul.sub-menu li a:hover, #site-navigation ul.children li a:hover{';
			$fast_food_pizza_custom_css .='color: '.esc_attr($fast_food_pizza_sub_menu_hover_color).' !important;';
	$fast_food_pizza_custom_css .='}';	

	// Sub menu bg color
	$fast_food_pizza_sub_menu_bg_color = get_theme_mod('fast_food_pizza_sub_menu_bg_color');
	$fast_food_pizza_custom_css .='#site-navigation ul.sub-menu li a, #site-navigation ul.children li a{';
			$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_sub_menu_bg_color).';';
	$fast_food_pizza_custom_css .='}';	

	// Sub menu bg hover color
	$fast_food_pizza_sub_menu_bg_hover_color = get_theme_mod('fast_food_pizza_sub_menu_bg_hover_color');
	$fast_food_pizza_custom_css .='#site-navigation ul.sub-menu li a:hover, #site-navigation ul.children li a:hover{';
			$fast_food_pizza_custom_css .='background-color: '.esc_attr($fast_food_pizza_sub_menu_bg_hover_color).';';
	$fast_food_pizza_custom_css .='}';	

	// site logo margin 
	$fast_food_pizza_logo_margin = get_theme_mod('fast_food_pizza_logo_margin', '');
	$fast_food_pizza_custom_css .='.logo{';
	$fast_food_pizza_custom_css .='margin: '.esc_attr($fast_food_pizza_logo_margin).'px ;';
	$fast_food_pizza_custom_css .='}';

	