<style>
  .carousel-container {
    position: relative;
    overflow: hidden;
  }

  .carousel-track {
    display: flex;
    transition: transform 0.3s ease-in-out;
  }

  .carousel-card {
    flex: 0 0 10%;
    max-width: 10%;
    padding: 0.5rem;
    box-sizing: border-box;
  }

  .carousel-card img {
    width: 100%;
    height: auto;
    display: block;
    border-radius: 5px;
  }

  /* Responsivo para tablets */
  @media (max-width: 992px) {
    .carousel-card {
      flex: 0 0 20%;
      max-width: 20%;
    }
  }

  /* Responsivo para celulares grandes */
  @media (max-width: 768px) {
    .carousel-card {
      flex: 0 0 33.3333%;
      max-width: 33.3333%;
    }
  }

  /* Responsivo para celulares pequenos */
  @media (max-width: 576px) {
    .carousel-card {
      flex: 0 0 50%;
      max-width: 50%;
    }
  }

  .carousel-controls {
    text-align: center;
    margin-top: 1rem;
  }

  .carousel-btn {
    margin: 0 10px;
    padding: 0.5rem 1rem;
    font-size: 1.2rem;
  }
</style>

<div class="carousel-container">
  <div class="carousel-track" id="carouselTrack">
    <?php for ($i = 0; $i < 20; $i++): ?>
      <div class="carousel-card">
        <div class="card">
          <img src="./img/it-capa.png" class="card-img-top" alt="It">
          <div class="card-body text-center">
            <h6 class="text-danger font-weight-bolder">It - A Coisa</h6>
          </div>
        </div>
      </div>
    <?php endfor; ?>
  </div>
</div>

<div class="carousel-controls">
  <button class="carousel-btn" onclick="scrollCarousel(-1)">◀</button>
  <button class="carousel-btn" onclick="scrollCarousel(1)">▶</button>
</div>

<script>
  const track = document.getElementById("carouselTrack");
  let currentIndex = 0;

  function getVisibleCards() {
    if (window.innerWidth <= 576) return 2;
    if (window.innerWidth <= 768) return 3;
    if (window.innerWidth <= 992) return 5;
    return 10;
  }

  function scrollCarousel(direction) {
    const totalCards = track.children.length;
    const visibleCards = getVisibleCards();
    const maxIndex = totalCards - visibleCards;

    currentIndex += direction;

    if (currentIndex < 0) currentIndex = 0;
    if (currentIndex > maxIndex) currentIndex = maxIndex;

    const cardWidth = track.children[0].offsetWidth;
    track.style.transform = `translateX(-${cardWidth * currentIndex}px)`;
  }

  // Redimensionamento responsivo
  window.addEventListener('resize', () => {
    scrollCarousel(0); // Recalcula posição quando mudar o tamanho da tela
  });
</script>
