<?php  
	function CadastrarCategoria($categoria, $pagina){
		global $con;

		$sql = 'insert into tb_categoria set nome_categoria = ?';
		$result = $con->prepare($sql);
		$result->bind_param('s', $categoria);
		if($result->execute()){
			Confirma("Cadastrado com sucesso!", $pagina);
		}
		else{
			Erro("Deu ruimmm!");
		}
	}

	function ListarCategorias(){
		global $con;

		$sql = 'select id_categoria, nome_categoria
				from tb_categoria
				order by nome_categoria asc';
		$result = $con->prepare($sql);
		$result->execute();
		$result->store_result();
		$result->bind_result($id, $categoria);
		$listar = [];
		while($result->fetch()){
			$listar[] = [
				'id'		=> $id,
				'categoria'	=> $categoria
			];
		}
		$result->close();
		return $listar;
	}
?>