<?php  
function TotalFilmes(){
	global $con;

	$sql = 'select count(*) as total from film';
	$res = $con->prepare($sql);
	$res->execute();
	$res->bind_result($total);
	$listar = [];
	if($res->fetch()){
		$listar[] = ['total'=>$total];
	}
	return $listar;
}

function FilmesDisponiveis(){
	global $con;

	$sql = 'select 
	count(distinct inventory.film_id) as "disponivel"
	from film
	inner join inventory on film.film_id = inventory.film_id';
	$res = $con->prepare($sql);
	$res->execute();
	$res->bind_result($totalDisponivel);
	if($res->fetch()){
		$listar[] = ['totalDisponivel'=>$totalDisponivel];
	}
	$res->close();
	return $listar;
}

function FilmesIndisponiveis(){
	global $con;

	$sql = 'select
	count(*) as total
	from film
	left join inventory on film.film_id = inventory.film_id
	where
	inventory.film_id is null';
	$res = $con->prepare($sql);
	$res->execute();
	$res->bind_result($totalIndisponivel);
	if($res->fetch()){
		$listar[] = ['totalIndisponivel'=>$totalIndisponivel];
	}
	$res->close();
	return $listar;
}

function TotalClientes(){
	global $con;

	$sql = 'select count(*) as "total" from customer';
	$res = $con->prepare($sql);
	$res->execute();
	$res->bind_result($totalClientes);
	if($res->fetch()){
		$listar[] = ['totalClientes'=>$totalClientes];
	}
	$res->close();
	return $listar;
}

function LocacaoAberto(){
	global $con;

	$sql = 'select count(*) as "aberto" from rental where return_date is null';
	$res = $con->prepare($sql);
	$res->execute();
	$res->bind_result($LocacaoAberto);
	if($res->fetch()){
		$listar[] = ['locacaoAberto'=>$LocacaoAberto];
	}
	$res->close();
	return $listar;
}

function ListarFilmes($tipoRelatorio){

}

function ListarClientes(){
	global $con;

	$sql = 'select
			customer.customer_id as "id",
			customer.store_id as "loja",
			concat(first_name, " ", last_name) as "cliente",
			email,
			customer.address_id as "endereco_id",
			address as "endereco",
			district as "distrito",
			phone as "telefone",
			active as "status",
			create_date as "registro"
			from customer
			inner join address on 
			address.address_id = customer.address_id
			order by loja asc, cliente asc';
	$res = $con->prepare($sql);
	$res->execute();
	$res->store_result();
	$res->bind_result($id, $loja, $cliente, $email, $endereco_id, $endereco, $distrito, $telefone, $status, $registro);
	$listar = [];
	while($res->fetch()){
		$listar[] = [
			'id' 			=> $id,
			'loja' 			=> $loja,
			'cliente'		=> $cliente,
			'email' 		=> $email,
			'endereco_id' 	=> $endereco_id,
			'endereco' 		=> $endereco,
			'distrito' 		=> $distrito,
			'telefone' 		=> $telefone,
			'status'		=> $status,
			'registro'		=> $registro
		];
	}
	$res->close();
	return $listar;
}
?>