<?php  
require_once 'header.php';
require_once './dashboard/function.php';
require_once './dashboard/modal.php';
require_once './dashboard/script.php';
$page = 'verClientes.php';
?>
<style>
	.card{border-color: grey; margin-bottom: 3%;}
</style>
<body class="bg-dark">
	<div class="container-fluid">
		<div class="row">
			<div class="col-sm-12">
				<?php require_once 'navbar.php'; ?>
			</div>
		</div>
		<div class="row">
			<div class="col-sm-12">
				<h3 class="font-weight-bolder text-white">
					Lista de Clientes
				</h3>
			</div>
		</div>
		<div class="row">
			<div class="col-sm-12">
				<div class="table-responsive">
					<table class="table table-bordered table-hover text-white">
						<thead>
							<tr>
								<th class="text-center">ID</th>
								<th class="text-center">Loja</th>
								<th>Cliente</th>
								<th>E-mail</th>
								<th>Endereço</th>
								<th>Distrito</th>
								<th class="text-center">Telefone</th>
								<th class="text-center">Status</th>
								<th class="text-center">Cadastrado em</th>
								<th></th>
							</tr>
						</thead>
						<tbody>
						<?php  
						$listar = ListarClientes();
						if(is_array($listar)){
							if(count($listar) > 0){
								foreach($listar as $l){
									if($l['status'] == 1){
										$badge = 'badge-success';
										$flag = 'ativo';
									}
									else if($l['status'] == 0){
										$badge = 'badge-danger';
										$flag = 'inativo';
									}
						?>
							<tr>
								<td class="text-center">
									<?php echo $l['id']; ?>
								</td>
								<td class="text-center">
									<?= $l['loja']; ?>
								</td>
								<td>
									<?= $l['cliente']; ?>
								</td>
								<td>
									<?= $l['email']; ?>
								</td>
								<td>
									<?= $l['endereco']; ?>
								</td>
								<td>
									<?= $l['distrito']; ?>
								</td>
								<td class="text-center">
									<?= $l['telefone']; ?>
								</td>
								<td class="text-center">
									<span class="badge <?= $badge; ?>">
										<?= $flag; ?>
									</span>
								</td>
								<td class="text-center">
									<?= date("d/m/Y", strtotime($l['registro'])); ?>
								</td>
								<td class="text-center">
									<button 
										class="btn btn-info">
										<i class="bi bi-pencil"></i>
									</button>
									<button 
										class="btn btn-warning text-white">
										<i class="bi bi-arrow-clockwise"></i>
									</button>
									<button 
										class="btn btn-danger">
										<i class="bi bi-trash3"></i>
									</button>
								</td>
							</tr>
						<?php  
								}
							}
						}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</body>
</html>