-- MySQL Script generated by MySQL Workbench
-- Wed Jul 30 21:53:01 2025
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `mydb` DEFAULT CHARACTER SET utf8 ;
USE `mydb` ;

-- -----------------------------------------------------
-- Table `mydb`.`TB_USUARIO`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_USUARIO` (
  `cd_usuario` INT NOT NULL AUTO_INCREMENT,
  `nome_usuario` VARCHAR(60) NOT NULL,
  `email_usuario` VARCHAR(60) NOT NULL,
  `senha_usuario` VARCHAR(64) NOT NULL,
  `status_usuario` CHAR(1) NOT NULL DEFAULT '1',
  `data_registro_usuario` DATETIME NOT NULL DEFAULT current_timestamp,
  PRIMARY KEY (`cd_usuario`),
  UNIQUE INDEX `nm_email_UNIQUE` (`email_usuario` ASC) VISIBLE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_CAROUSEL`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_CAROUSEL` (
  `cd_carousel` INT NOT NULL AUTO_INCREMENT,
  `url_carousel` VARCHAR(100) NOT NULL,
  `status_carousel` CHAR(1) NOT NULL DEFAULT '1',
  `active_carousel` VARCHAR(6) NULL,
  `descricao_carousel` VARCHAR(80) NOT NULL,
  PRIMARY KEY (`cd_carousel`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_LOCAL`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_LOCAL` (
  `cd_local` INT NOT NULL AUTO_INCREMENT,
  `tipo_local` VARCHAR(20) NOT NULL,
  `nome_local` VARCHAR(150) NOT NULL,
  `geolocalizacao` LONGTEXT NULL,
  `id_usuario` INT NOT NULL,
  PRIMARY KEY (`cd_local`),
  INDEX `fk_TB_CONTATO_TB_USUARIO_idx` (`id_usuario` ASC) VISIBLE,
  CONSTRAINT `fk_TB_CONTATO_TB_USUARIO`
    FOREIGN KEY (`id_usuario`)
    REFERENCES `mydb`.`TB_USUARIO` (`cd_usuario`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_SERVICO`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_SERVICO` (
  `cd_servico` INT NOT NULL AUTO_INCREMENT,
  `nome_servico` VARCHAR(45) NOT NULL,
  `descricao_servico` VARCHAR(150) NOT NULL,
  `valor_servico` DECIMAL(6,2) NOT NULL,
  `status_servico` CHAR(1) NOT NULL DEFAULT '1',
  `id_endereco` INT NOT NULL,
  PRIMARY KEY (`cd_servico`),
  INDEX `fk_TB_SERVICO_TB_CONTATO1_idx` (`id_endereco` ASC) VISIBLE,
  CONSTRAINT `fk_TB_SERVICO_TB_CONTATO1`
    FOREIGN KEY (`id_endereco`)
    REFERENCES `mydb`.`TB_LOCAL` (`cd_local`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_FUNCIONARIO`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_FUNCIONARIO` (
  `cd_funcionario` INT NOT NULL AUTO_INCREMENT,
  `nome_funcionario` VARCHAR(60) NOT NULL,
  `nome_funcao` VARCHAR(60) NOT NULL,
  `url_imagem_funcionario` VARCHAR(200) NULL,
  PRIMARY KEY (`cd_funcionario`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_SERVICO_FUNCIONARIO`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_SERVICO_FUNCIONARIO` (
  `id_servico` INT NOT NULL,
  `id_funcionario` INT NOT NULL,
  PRIMARY KEY (`id_servico`, `id_funcionario`),
  INDEX `fk_TB_SERVICO_has_TB_FUNCIONARIO_TB_FUNCIONARIO1_idx` (`id_funcionario` ASC) VISIBLE,
  INDEX `fk_TB_SERVICO_has_TB_FUNCIONARIO_TB_SERVICO1_idx` (`id_servico` ASC) VISIBLE,
  CONSTRAINT `fk_TB_SERVICO_has_TB_FUNCIONARIO_TB_SERVICO1`
    FOREIGN KEY (`id_servico`)
    REFERENCES `mydb`.`TB_SERVICO` (`cd_servico`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_TB_SERVICO_has_TB_FUNCIONARIO_TB_FUNCIONARIO1`
    FOREIGN KEY (`id_funcionario`)
    REFERENCES `mydb`.`TB_FUNCIONARIO` (`cd_funcionario`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_AVALIACAO`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_AVALIACAO` (
  `cd_avaliacao` INT NOT NULL AUTO_INCREMENT,
  `cliente_avaliacao` VARCHAR(45) NOT NULL,
  `descricao_avaliacao` TEXT NOT NULL,
  `data_registro_avaliacao` DATETIME NOT NULL DEFAULT current_timestamp,
  `id_servico` INT NOT NULL,
  PRIMARY KEY (`cd_avaliacao`),
  INDEX `fk_TB_AVALIACAO_TB_SERVICO1_idx` (`id_servico` ASC) VISIBLE,
  CONSTRAINT `fk_TB_AVALIACAO_TB_SERVICO1`
    FOREIGN KEY (`id_servico`)
    REFERENCES `mydb`.`TB_SERVICO` (`cd_servico`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_CLIENTE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_CLIENTE` (
  `cd_cliente` INT NOT NULL AUTO_INCREMENT,
  `nome_cliente` VARCHAR(80) NOT NULL,
  `email_cliente` VARCHAR(60) NOT NULL,
  `telefone_cliente` VARCHAR(15) NOT NULL,
  `senha_cliente` VARCHAR(64) NOT NULL,
  `data_nascimento` DATE NOT NULL,
  `data_registro_cliente` DATETIME NOT NULL DEFAULT current_timestamp,
  `observacao_cliente` LONGTEXT NULL,
  PRIMARY KEY (`cd_cliente`),
  UNIQUE INDEX `email_cliente_UNIQUE` (`email_cliente` ASC) VISIBLE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`TB_AGENDA`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`TB_AGENDA` (
  `cd_agenda` INT NOT NULL AUTO_INCREMENT,
  `data_agenda` DATE NOT NULL,
  `hora_agenda` TIME NOT NULL,
  `data_registro_agenda` DATETIME NOT NULL DEFAULT current_timestamp,
  `id_servico` INT NOT NULL,
  `observacao_agenda` TEXT NULL,
  `id_funcionario_agenda` INT NULL,
  `id_funcionario_registro_agenda` INT NULL,
  `id_cliente` INT NOT NULL,
  `status_agenda` CHAR(1) NOT NULL,
  PRIMARY KEY (`cd_agenda`),
  INDEX `fk_TB_AGENDA_TB_SERVICO1_idx` (`id_servico` ASC) VISIBLE,
  INDEX `fk_TB_AGENDA_TB_FUNCIONARIO1_idx` (`id_funcionario_agenda` ASC) VISIBLE,
  INDEX `fk_TB_AGENDA_TB_FUNCIONARIO2_idx` (`id_funcionario_registro_agenda` ASC) VISIBLE,
  INDEX `fk_TB_AGENDA_TB_CLIENTE1_idx` (`id_cliente` ASC) VISIBLE,
  CONSTRAINT `fk_TB_AGENDA_TB_SERVICO1`
    FOREIGN KEY (`id_servico`)
    REFERENCES `mydb`.`TB_SERVICO` (`cd_servico`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_TB_AGENDA_TB_FUNCIONARIO1`
    FOREIGN KEY (`id_funcionario_agenda`)
    REFERENCES `mydb`.`TB_FUNCIONARIO` (`cd_funcionario`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_TB_AGENDA_TB_FUNCIONARIO2`
    FOREIGN KEY (`id_funcionario_registro_agenda`)
    REFERENCES `mydb`.`TB_FUNCIONARIO` (`cd_funcionario`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_TB_AGENDA_TB_CLIENTE1`
    FOREIGN KEY (`id_cliente`)
    REFERENCES `mydb`.`TB_CLIENTE` (`cd_cliente`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
