<!DOCTYPE html>
<html lang="pt-br">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Barber Shop</title>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
	<script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
	<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>

	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
	<script>
	    $(document).ready(function(){
	       $('#myModal').modal('show');
	    });

	    $('#myModal').on('shown.bs.modal', function(){
	      $('#myInput').trigger('focus');
	    });
	</script>
</head>
<body>
<?php  
	require_once 'conect.php';

	if(!empty($_POST)){
		if($_POST['action'] == "Cadastrar"){
			CadastrarCliente(
				$_POST['nome'], 
				$_POST['email'],
				$_POST['telefone'],
				$_POST['password'],
				$_POST['retype_password'],
				$_POST['data_nascimento']
			);
		}
		else if($_POST['action'] == "Entrar"){
			ValidarLogin($_POST['email'], $_POST['password'], $_GET['tipo']);
		}
	}

	function CadastrarCliente($nome, $email, $telefone, $senha, $senha2, $data_nasc){
		global $con;

		if($senha == $senha2){
			$sql = 'insert into tb_cliente set 
					nome_cliente = ?,
					email_cliente = ?,
					telefone_cliente = ?,
					senha_cliente = sha2(?, 256),
					data_nascimento = ?';
			$res = $con->prepare($sql);
			$res->bind_param('sssss', $nome, $email, $telefone, $senha, $data_nasc);
			if($res->execute()){
				$res->close();
				Confirma("Cliente cadastrado com sucesso!", "login.php");
			}
			else{
				$res->close();
				Erro("Ops! Cadastro não realizado!");
			}
		}
		else{
			Erro("As senhas não conferem! Redigite as senhas!");
		}
	}

	function ValidarLogin($email, $senha, $tipo){
		global $con;
		if($tipo == "cliente"){
			$redirect = "index.php";
			$sql = 'select cd_cliente, nome_cliente 
					from tb_cliente 
					where
					email_cliente = ? and 
					senha_cliente = sha2(?, 256) and 
					active = "1"';
		}
		else if($tipo == "admin"){
			$redirect = "painel/index.php";
			$sql = 'select cd_usuario, nome_usuario 
					from tb_usuario
					where
					email_usuario = ? and 
					senha_usuario = sha2(?, 256) and
					status_usuario = "1"';
		}
		$res = $con->prepare($sql);
		$res->bind_param('ss', $email, $senha);
		$res->execute();
		$res->bind_result($id, $cliente);
		if($res->fetch()){
				session_start();
				$_SESSION['id'] = $id;
				$_SESSION['cliente'] = $cliente;
				$_SESSION['tipo'] = $tipo;
				$res->close();
				Confirma("Bem vindo ".$_SESSION['cliente'], $redirect);
			}	
		else{
			Erro("deu ruim");
		}
		
	}

	function Confirma($msg, $redirect){
		echo '
			<div class="modal fade" id="myModal" data-backdrop="static">
				<div class="modal-dialog modal-md">
					<div class="modal-content">
						<div class="modal-body text-center" style="height:250px;">
							<i class="bi bi-check-circle-fill text-success font-weight-bolder" style="font-size:84pt;"></i>
							<h4 class="font-weight-bolder text-success">
								'.$msg.'
							</h4>
						</div>
						<div class="modal-footer">
							<button 
								class="btn btn-success" 
								onclick="redirect()"
								style="width:100%;">OK</button>
						</div>
					</div>
				</div>
			</div>
			<script>
				function redirect(){
					location.href = "'.$redirect.'";
				}				
			</script>
		';
	}

	function Erro($msg){
		echo '
			<div class="modal fade" id="myModal" data-backdrop="static">
				<div class="modal-dialog modal-md">
					<div class="modal-content">
						<div class="modal-body text-center" style="height:250px;">
							<i class="bi bi-x-circle-fill text-danger font-weight-bolder" style="font-size:84pt;"></i>
							<h4 class="font-weight-bolder text-danger">
								'.$msg.'
							</h4>
						</div>
						<div class="modal-footer">
							<button 
								class="btn btn-danger" 
								onclick="redirect()"
								style="width:100%;">OK</button>
						</div>
					</div>
				</div>
			</div>
			<script>
				function redirect(){
					history.go(-1);
				}				
			</script>
		';
	}
?>
</body>
</html>